import java.awt.*;
import java.util.*;
import java.text.*;
import java.applet.*;
import javax.swing.*;

/** An applet that displays a clock with the time
    at which the instance was created and the time
    whenever it is repainted */
public class Clock extends JApplet {
   private int xMid;   // (xmid, ymix) is the center of the panel
   private int yMid;
   private int radius; // The radius of the clock
   
   /** Paint the clock using g */
   public void paint(Graphics g) {
      setBackground(new Color(255, 235, 222));
      g.setColor(Color.black);
      // Set the clock parameters based on the size of this JApplet
         xMid= 75;
         yMid= 75;
         radius= 60;
         
      // Store in cal the current date and time
         GregorianCalendar cal= new
            GregorianCalendar(Locale.getDefault());
            
      drawCircle(g);
      // Draw the second hand
         int sec= cal.get(GregorianCalendar.SECOND);
         drawHand(radius*0.95, sec*2*Math.PI/60.0, 1, g);
      // Draw the minute hand
         int min= cal.get(GregorianCalendar.MINUTE);
         drawHand(radius*0.7, min*2*Math.PI/60.0, 2, g);
      // Draw the hour hand
         int hr= cal.get(GregorianCalendar.HOUR);
         drawHand(radius*0.55, (hr + min/60.0)*2*Math.PI/12.0, 3, g);
   }   
   
   /** Draw the clock with Graphics g (no hands but with numbers) */
   public void drawCircle(Graphics g) {
      Color save= g.getColor();
      g.setColor(Color.red);
      g.drawOval(xMid-radius, yMid-radius, 2*radius, 2*radius);
      g.drawString("3",  xMid+radius-8, yMid+4);
      g.drawString("6",  xMid-3, yMid+radius+10);
      g.drawString("9",  xMid-radius+2, yMid+4);
      g.drawString("12", xMid-6, yMid-radius+10);
      g.setColor(save);
   }
   
   /** Draw hand with length len, and angle ang, using g.
       Parameter fatness is the number of lines to draw (in 1..3) 
       in order to get fat or thin hands */
   public void drawHand(double len, double ang, int fatness, Graphics g) {
      Color save= g.getColor();
      g.setColor(Color.black);
      int x1= (int)(xMid + Math.ceil(len*Math.sin(ang)));
      int y1= (int)(yMid - Math.ceil(len*Math.cos(ang)));
      g.drawLine(xMid, yMid, x1, y1);
      if (fatness == 1) return;
      g.drawLine(xMid+1, yMid, x1+1, y1);
      g.drawLine(xMid, yMid+1, x1, y1+1);
      if (fatness == 2) return;
      g.drawLine(xMid-1, yMid, x1-1, y1);
      g.drawLine(xMid, yMid-1, x1, y1-1);
      g.setColor(save);
   }
}
